import './button.scss';

export const createButton = ({
  version = 'primary',
  label,
  isDisabled = false,
  hasIcon = false,
}) => {
  const btn = document.createElement('button');
  btn.type = 'button';
  const btnIcon = hasIcon ? `
  <span class="c-button-icon">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
      <g clip-path="url(#clip0_4005_2071)">
        <mask id="mask0_4005_2071" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="24">
          <rect width="24" height="24" fill="white"/>
        </mask>
        <g mask="url(#mask0_4005_2071)">
          <path fill-rule="evenodd" clip-rule="evenodd" d="M20 6C20 4.89543 19.1046 4 18 4H6C4.89543 4 4 4.89543 4 6V18C4 19.1046 4.89543 20 6 20H18C19.1046 20 20 19.1046 20 18V6ZM12 8C9.79086 8 8 9.79086 8 12C8 14.2091 9.79086 16 12 16C14.2091 16 16 14.2091 16 12C16 9.79086 14.2091 8 12 8Z"/>
        </g>
      </g>
      <defs>
        <clipPath id="clip0_4005_2071">
          <rect width="24" height="24" fill="white"/>
        </clipPath>
      </defs>
    </svg>
  </span>
  ` : '';

  btn.innerHTML = `${btnIcon}${label}`;

  // const mode =  ? 'storybook-button--primary' : 'storybook-button--secondary';
  const disabled = isDisabled ? 'c-button--disabled' : '';
  btn.className = ['c-button', disabled, `c-button--${version}`].join(' ');

  return btn;
};
