import './list.scss';

export const createList = ({
  version = 'normal',
  variants = 'normal',
  title,
  subTitle,
  caption,
  subCaption,
  accordionBtn,
  isAccordion,
  isAccordionInner,
  isMulti,
  accordionEvent,
  accordionInnerExample,
  accordionInner,
  toggleIcon,
}) => {
  // トグルアイコンSVG
  toggleIcon = `
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" class="svg">
          <g id="svg-arrow">
            <path id="Vector 1" d="M10 16.5L15 11.5L10 6.5" stroke="#757575" stroke-width="2"/>
          </g>
        </svg>
  `


  // versionによって切り替え
  const multiVersions = [
    'Multi-Line',
  ];
  const subTitleVersions = [
    'normal',
    '2-Line(L2R1)',
    '2-Line(L2R2)',
  ];
  const subCaptionVersions = [
    'normal',
    '2-Line(L1R2)',
    '2-Line(L2R2)',
  ];

  isMulti = multiVersions.includes(version);

  if (variants == 'accordion') {
    isAccordion = true
  } else if (variants == 'accordionInner') {
    isAccordionInner = true
  }

  const background = isAccordionInner ? 'c-list-accordionInner' : 'c-list-primary';
  const accordion = isAccordion ? 'c-list-accordion' : '';
  const multi = isMulti ? 'c-list-multi': '';

  // DOM
  const ListWrapDom = document.createElement('ul');
  title = `<p class="c-list-title">${title}</p>`;
  subTitle = subTitleVersions.includes(version) ? `<p class="c-list-title-sub">${subTitle}</p>` :'';
  caption = caption ? `<p class="c-list-caption">${caption}</p>` :'';
  subCaption = subCaptionVersions.includes(version) ? `<p class="c-list-caption-sub">${subCaption}</p>` :'';
  accordionBtn = isAccordion ? `<div class="c-list-accordionBtn">${toggleIcon}</div>` : '';
  accordionEvent = isAccordion ? `onclick="toggleList(this)" role="button" tabindex="0" data-name="accordion"` : '';

  // class付与
  ListWrapDom.classList = 'c-list-wrapper';

  // 2層目のDOMの例（表示確認用）
  accordionInnerExample = isAccordion ? `  <li class="c-list-inner c-list-accordionInner  ">
          <div class="c-list-row">
            <div class="c-list-title-wrapper">
              <p class="c-list-title">リストタイトル</p>
            </div>
            <div class="c-list-caption-wrapper">
              <p class="c-list-caption">キャプション</p>
              <p class="c-list-caption-sub">補足情報</p>
            </div>
          </div>
        </li>`:'';

  // 2階層目のDOM
  accordionInner = isAccordion ? `
      <ul class="c-list-accordionInner-wrapper">
        ${accordionInnerExample}
        ${accordionInnerExample}
        ${accordionInnerExample}
      </ul>
  `:'';

  // html作成
  ListWrapDom.innerHTML = `
    <li class="c-list-inner ${background} ${accordion} ${multi}" ${accordionEvent}>
      <div class="c-list-row">
        <div class="c-list-title-wrapper">
          ${title}
          ${subTitle}
        </div>
        <div class="c-list-caption-wrapper">
          ${caption}
          ${subCaption}
        </div>
        ${accordionBtn}
      </div>
      ${accordionInner}
    </li>
  `

  return ListWrapDom;
};

// アコーディオンのトグル
window.toggleList =(list) => {
  list.classList.toggle('-isOpen');
}

// バブリング制御
document.addEventListener('DOMContentLoaded', function() {
  var secondaryLists = document.querySelectorAll('.c-list-accordionInner-wrapper');

  secondaryLists.forEach(function(list) {
    list.addEventListener('click', function(event) {
      event.stopPropagation(); 
    });
  });
});