import './textField.scss';

export const createTextField = ({
  version = 'outlined',
  label,
  placeholder,
  errorMessage,
  isDisabled = false,
  isRequired = false,
}) => {
  const textFieldWrapDom = document.createElement('div');

  // class付与
  const disabled = isDisabled ? 'c-textField--disabled' : '';
  const disabledWrap = isDisabled ? 'c-textField-wrap--disabled' : '';
  const required = isRequired ? 'c-textField--required' : '';
  const error = errorMessage ? 'c-textField--error' : '';
  const textFieldClass = ['c-textField', disabled, required, error, `c-textField--${version}`].join(' ')
  const textFieldWrapClass = ['c-textField-wrap', disabledWrap].join(' ')
  textFieldWrapDom.className = textFieldWrapClass

  // html作成
  textFieldWrapDom.innerHTML = `
    <div class="c-textField-label-wrap">
      <label class="c-textField-label" for="selector">${ label }</label>
      ${isRequired ? `<p class="c-textField-required">必須</p>` : ''}
    </div>
    <input class="${textFieldClass}" placeholder="${placeholder}">
    ${errorMessage ? `<p class="c-textField-error">${errorMessage}</p>` : ''}
  `


  return textFieldWrapDom;
};
