import './checkBox.scss';

export const createCheckBox = ({
  version = 'primary',
  input,
  inputId,
  isDisabled = false,
  errorMessage,
}) => {
  const checkBoxWrapDom = document.createElement('div');

  // class付与
  const disabled = isDisabled ? 'c-checkBox--disabled' : '';
  const disabledWrap = isDisabled ? 'c-checkBox-wrap--disabled' : '';
  const error = errorMessage ? 'c-checkBox--error' : '';
  const checkBoxClass = ['c-checkBox', disabled, error, `c-checkBox--${version}`].join(' ')
  const checkBoxWrapClass = ['c-checkBox-wrap', disabledWrap].join(' ')
  checkBoxWrapDom.className = checkBoxWrapClass

  // html作成
  checkBoxWrapDom.innerHTML = `
    <div class="c-checkBox-inner">
      <input type="checkbox" id="checkbox-${inputId}" name="checkboxGroup" value="${input}" class="${checkBoxClass}">
      <label for="checkbox-${inputId}" class="c-checkBox-label">${input}</label>
    </div>
    ${errorMessage ? `<p class="c-checkBox-error">${errorMessage}</p>` : ''}
  `
  return checkBoxWrapDom;
};
