import { createDialog } from './Dialog';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Operation/Dialog',
  tags: ['autodocs'],
  render: ({ label, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createDialog({ label, ...args });
  },
  argTypes: {
    iconSrc:{
      control: { type: 'select' },
      options: [
        '/assets/img/connection.png',
        '/assets/img/dummy.png',
      ],
    },
    title: { control: 'text' },
    text: { control: 'text' },
    primaryBtnText: { control: 'text' },
    secondaryBtnText: { control: 'text' },
    plainBtnText: { control: 'text' },
    hasPrimaryButton :  { control: 'boolean', description: '承認ボタンの表示切替' },
    hasSecondaryButton :  { control: 'boolean', description: '否認ボタンの表示切替' },
    hasPlainButton :  { control: 'boolean', description: 'キャンセルボタンの表示切替' },
    isAlignLeft:{ control: 'boolean', description: 'タイトルとテキストを左寄せにします' },
  },
};


export const Modules = {
  args: {
    iconSrc: '/assets/img/dummy.png',
    title: 'メッセージタイトル＊＊＊＊＊＊＊＊＊＊',
    text: '説明文のテキスト＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊',
    primaryBtnText: '承認',
    secondaryBtnText: '否認',
    plainBtnText: 'キャンセル',
    hasPrimaryButton: true,
    hasSecondaryButton: true,
    hasPlainButton: true,
    isAlignLeft: false,
  },
};


export const Connection = {
  args: {
    iconSrc: '/assets/img/connection.png',
    title: '機器との接続を開始します',
    hasPrimaryButton :  true,
    hasSecondaryButton :  true,
    hasPlainButton :  false,
    primaryBtnText: 'OK',
    secondaryBtnText:'キャンセル',
  },
};


export const Info = {
  args: {
    title:'お知らせ',
    text:'ver.2.0.1の更新内容<br><ul><li>文字入力に関する軽微な修正を反映</li></ul>',
    hasPrimaryButton:false,
    hasSecondaryButton :  true,
    hasPlainButton : false ,
    secondaryBtnText:'閉じる',
  },
};




