import './radioButton.scss';

export const createRadioButton = ({
  version = 'primary',
  input,
  inputId,
  input2,
  inputId2,
  isDisabled = false,
  errorMessage,
}) => {
  const radioButtonWrapDom = document.createElement('div');

  // class付与
  const disabled = isDisabled ? 'c-radioButton--disabled' : '';
  const disabledWrap = isDisabled ? 'c-radioButton-wrap--disabled' : '';
  const error = errorMessage ? 'c-radioButton--error' : '';
  const radioButtonClass = ['c-radioButton', disabled, error, `c-radioButton--${version}`].join(' ')
  const radioButtonWrapClass = ['c-radioButton-wrap', disabledWrap].join(' ')
  radioButtonWrapDom.className = radioButtonWrapClass

  // html作成
  radioButtonWrapDom.innerHTML = `
    <div class="c-radioButton-inner">
      <div class="${radioButtonClass}">
        <input type="radio" id="radio-${inputId}" name="radioGroup" value="${input}" class="c-radioButton-icon">
        <label for="radio-${inputId}" class="c-radioButton-label">${input}</label>
      </div>
      <div class="${radioButtonClass}">
        <input type="radio" id="radio-${inputId2}" name="radioGroup" value="${input2}" class="c-radioButton-icon">
        <label for="radio-${inputId2}" class="c-radioButton-label">${input2}</label>
      </div>
    </div>
    ${errorMessage ? `<p class="c-radioButton-error">${errorMessage}</p>` : ''}
  `
  return radioButtonWrapDom;
};
