import { createToggle } from './Toggle';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Operation/Toggle',
  tags: ['autodocs'],
  render: ({ label, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createToggle({ label, ...args });
  },
  argTypes: {
    input: { control: 'text' },
    inputId: { control: 'text' },
    version: {
      control: { type: 'select' },
      options: ['primary'],
    },
    isDisabled: { control: 'boolean' },
    errorMessage: { control: 'text', description: 'エラーメッセージを入力するとエラー状態になります' },
  },
};

// More on writing stories with args: https://storybook.js.org/docs/writing-stories/args
export const Primary = {
  args: {
    version: 'primary',
    input: 'ON/OFF',
    inputId: 'on-off',
    isDisabled: false,
    errorMessage: '',
  },
};
