// https://github.com/storybookjs/storybook/issues/25256を参考にしたけど読み込まれてなさそう。
// viteのバージョンを5.0.8→5.0.0に下げることで対応


import { defineConfig } from 'vite';
import path from 'path';

/** @type {import('vite').UserConfig} */

export default defineConfig({
  build: {
    assetsInclude: ['**/*.zip'],
    rollupOptions: {
      input: {
        'operation': path.resolve(__dirname, 'src/operation/index.js'),
        'information': path.resolve(__dirname, 'src/information/index.js'),
      },
      output: {
        assetFileNames: '[name]/assets/css/index.css'
      }
    }
  },
});
