import React from 'react';
import { DocsContainer } from '@storybook/addon-docs';
import { useDarkMode } from 'storybook-dark-mode';
import { themes } from '@storybook/theming';


/** @type { import('@storybook/html').Prevddiew } */
import '../src/scss/reset.scss';
import '../src/scss/global.scss';

const preview = {
  parameters: {
    actions: { argTypesRegex: '^on[A-Z].*' },
    controls: {
      matchers: {
        color: /(background|color)$/i,
        date: /Date$/i,
      },
    },
    docs: {
      container: (props) => {
        const isDark = useDarkMode();
        const currentProps = { ...props };
        currentProps.theme = isDark ? themes.dark : themes.light;
        return React.createElement(DocsContainer, currentProps);
      },
    },
    darkMode: {
      stylePreview: true,
      classTarget: 'html',
      dark: { ...themes.dark, appBg: 'black' },
    }
  },
};

export default preview;
