import { createButton } from './Button';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Information/Button',
  tags: ['autodocs'],
  render: ({ label, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createButton({ label, ...args });
  },
  argTypes: {
    label: { control: 'text' },
    version: {
      control: { type: 'select' },
      options: ['primary', 'secondary', 'tertiary', 'plain'],
    },
    isDisabled: { control: 'boolean' },
    hasIcon: { control: 'boolean' },
  },
};

// More on writing stories with args: https://storybook.js.org/docs/writing-stories/args
export const Primary = {
  args: {
    version: 'primary',
    label: 'プライマリーボタン',
    isDisabled: false,
    hasIcon: false,
  },
};

export const Secondary = {
  args: {
    version: 'secondary',
    label: 'セカンダリーボタン',
  },
};

export const Tertiary = {
  args: {
    version: 'tertiary',
    label: '汎用ボタン',
  },
};

export const Plain = {
  args: {
    version: 'plain',
    label: 'プレーンボタン',
  },
};
