import './Dialog.scss';
import '../Button/Button.scss';

export const createDialog = ({
  title,
  text,
  textAlign,
  isAlignLeft,
  primaryBtnText,
  secondaryBtnText,
  plainBtnText,
  iconSrc,
  hasPrimaryButton = true,
  hasSecondaryButton = true,
  hasPlainButton = true,
}) => {
  // DOM
  const DialogContainerDom = document.createElement('div');
  const DialogTriggerButton = '<button type="button" class="c-button c-button--primary" data-dialog-button>dialogを開きます</button>'
  primaryBtnText = primaryBtnText ? primaryBtnText :'';
  secondaryBtnText = secondaryBtnText ? secondaryBtnText :'';
  plainBtnText = plainBtnText ? plainBtnText :'';
  textAlign = isAlignLeft ? '-align-left':'';
  iconSrc = iconSrc ? `<img class="c-dialog-icon" src="${iconSrc}">` :'';
  title = title ? `<p class="c-dialog-title ${textAlign}">${title}</p>` : '';
  text = text ? `<div class="c-dialog-text ${textAlign}">${text}</div>` :'';

  // 表示するボタン選択
  const btnPrimary = hasPrimaryButton ? `<button type="button" class="c-button c-button--primary ">${primaryBtnText}</button>` : '';
  const btnSecondary = hasSecondaryButton ? `<button type="button" class="c-button  c-button--secondary" data-dialog-close>${secondaryBtnText}</button>` : '';
  const btnPlain = hasPlainButton ? `<button type="button" class="c-button  c-button--plain" data-dialog-close>${plainBtnText}</button>` : '';



  // html作成
  const DialogWrap = `
    <div class="c-dialog-wrapper" data-dialog-content>
      <div class="c-dialog-bg" data-dialog-close></div>
      <div class="c-dialog-inner">
        ${iconSrc}
        ${title}
        ${text}
        ${btnPrimary}
        ${btnSecondary}
        ${btnPlain}
      </div>
    </div>
  `
  
  DialogContainerDom.classList.add('c-dialog-container')
  DialogContainerDom.setAttribute('data-dialog','')

  // storybook用のwrapper
  DialogContainerDom.innerHTML = `
    ${DialogTriggerButton}
    ${DialogWrap}
  `

  return DialogContainerDom;

};


// バブリング制御
document.addEventListener('DOMContentLoaded', () => {
  const dialogs = document.querySelectorAll('[data-dialog-content]')
  const dialogBtns = document.querySelectorAll('[data-dialog-button]')
  const dialogCloses = document.querySelectorAll('[data-dialog-close]')
  
  // init
  for (var i = 0; i < dialogs.length; i++) {
    dialogs[i].style.display = "none";
  }

  // ボタンがクリックされたら対応するモーダルを表示
  for (var i = 0; i < dialogBtns.length; i++) {
    dialogBtns[i].addEventListener('click', (btnEl) => {
      // 親を基準にチェックする
      const parent = btnEl.target.closest('[data-dialog]')
      const dialog = parent.querySelector('[data-dialog-content]')
      dialog.style.display = "block";
    });
  }

  // 背景がクリックされたらモーダルを非表示に
  for (var i = 0; i < dialogCloses.length; i++) {
    dialogCloses[i].addEventListener('click', (closeEl) => {
      // 親を基準にチェックする
      const parent = closeEl.target.closest('[data-dialog]')
      const dialog = parent.querySelector('[data-dialog-content]')
      dialog.style.display = "none"
    });
  }
});
