import { createList} from './List';


// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Information/List',
  tags: ['autodocs'],
  render: ({ version, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createList({ version, ...args });
  },
  argTypes: {
    version: {
      control: { type: 'select' },
      options: ['normal','1-line','2-Line(L1R2)', '2-Line(L2R1)', '2-Line(L2R2)', 'Multi-Line'],
    },
    variants: {
      control: { type: 'select' },
      options: ['normal', 'accordion', 'accordionInner'],
    },
    title:{ control: 'text'},
    subTitle:{ control: 'text'},
    caption:{ control: 'text',description: 'Multi-Lineは、キャプションテキストの分量を多くしてください'},
    subCaption:{ control: 'text'},
  },
};

// More on writing stories with args: https://storybook.js.org/docs/writing-stories/args
export const normal = {
  args: {
    version: 'normal',
    variants: 'normal',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L1R1 = {
  args: {
    version: '1-line',
    variants: 'normal',
    title:'リストタイトル',
    caption:'キャプション',
  },
};

export const L1R1Accordion = {
  args: {
    version: '1-line',
    variants: 'accordion',
    title:'リストタイトル',
    caption:'キャプション',
    isAccordion: true,
  },
};

export const L1R1Secondary = {
  args: {
    version: '1-line',
    variants: 'secondary',
    title:'リストタイトル',
    caption:'キャプション',
    isSecondary: true,
  },
};

export const L1R2 = {
  args: {
    version: '2-Line(L1R2)',
    variants: 'normal',
    title:'リストタイトル',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L1R2Accordion = {
  args: {
    version: '2-Line(L1R2)',
    variants: 'accordion',
    title:'リストタイトル',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L1R2Secondary = {
  args: {
    version: '2-Line(L1R2)',
    variants: 'secondary',
    title:'リストタイトル',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L2R1 = {
  args: {
    version: '2-Line(L2R1)',
    variants: 'normal',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
  },
};

export const L2R1Accordion = {
  args: {
    version: '2-Line(L2R1)',
    variants: 'accordion',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
  },
};

export const L2R1Secondary = {
  args: {
    version: '2-Line(L2R1)',
    variants: 'secondary',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
  },
};

export const L2R2 = {
  args: {
    version: '2-Line(L2R2)',
    variants: 'normal',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L2R2Accordion = {
  args: {
    version: '2-Line(L2R2)',
    variants: 'accordion',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const L2R2Secondary = {
  args: {
    version: '2-Line(L2R2)',
    variants: 'secondary',
    title:'リストタイトル',
    subTitle:'補足情報',
    caption:'キャプション',
    subCaption:'補足情報',
  },
};

export const Multi = {
  args: {
    version: 'Multi-Line',
    variants: 'normal',
    title:'リストタイトル',
    caption:'キャプション一行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション二行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション三行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊',
  },
};

export const MultiAccordion = {
  args: {
    version: 'Multi-Line',
    variants: 'accordion',
    title:'リストタイトル',
    caption:'キャプション一行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション二行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション三行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊',
  },
};

export const MultiSecondary = {
  args: {
    version: 'Multi-Line',
    variants: 'secondary',
    title:'リストタイトル',
    caption:'キャプション一行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション二行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊<br>キャプション三行目＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊＊',
  },
};
