import './table.scss';

export const createTable = ({
  version,
  checkbox,
  arrowIcon,
  threeDotIcon,
  Link,

}) => {
  const TableWrapDom = document.createElement('table');
  Link = `c-table-link`;

  // class付与
  TableWrapDom.classList = 'c-table'

  // チェックボックス
  checkbox = `<div class="c-checkBox-wrap ">
  <div class="c-checkBox-inner">
    <input type="checkbox" id="checkbox-selectA" name="checkboxGroup" value="" class="c-checkBox   c-checkBox--primary">
    <label for="checkbox-selectA" class="c-checkBox-label"></label>
  </div>
</div>`

// 三角アイコンSVG
arrowIcon = `
          <span class="arrow-wrapper" data-table-sort-btn="arrow">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" class="svg" xmlns="http://www.w3.org/2000/svg">
              <g id="svg-arrow">
                <path id="svg-arrow-path" d="M7 9L12 14L17 9" stroke="#757575" stroke-width="2"/>
              </g>
            </svg>
          </span>`;
threeDotIcon = `
<svg width="18" height="4" viewBox="0 0 18 4" fill="none" class="svg" xmlns="http://www.w3.org/2000/svg">
  <g id="svg-threedot">
    <circle id="Ellipse 1" cx="2" cy="2" r="2" fill="#757575"/>
    <circle id="Ellipse 2" cx="9" cy="2" r="2" fill="#757575"/>
    <circle id="Ellipse 3" cx="16" cy="2" r="2" fill="#757575"/>
  </g>
</svg>
`;



  // html作成
  TableWrapDom.innerHTML = `
  <thead>
    <tr>
      <th class="c-table-th">
        <button class="c-table-th-inner" data-table-sort="button">
          見出し1 ${arrowIcon}
        </button>
      </th>
      <th class="c-table-th">
        <button class="c-table-th-inner" data-table-sort="button">
          見出し2 ${arrowIcon}
        </button>
      </th>
      <th class="c-table-th">
        <button class="c-table-th-inner" data-table-sort="button">
          見出し3 ${arrowIcon}
        </button>
      </th>
      <th class="c-table-th">
        <button class="c-table-th-inner" data-table-sort="button">
          見出し4 ${arrowIcon}
        </button>
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="c-table-td ${Link}">
        <span class="c-table-td-inner">1値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">b値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">あ値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">ア値（セル）</span>
      </td>
    </tr>
    <tr>
      <td class="c-table-td ${Link}">
        <span class="c-table-td-inner">2値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">c値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">い値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">イ値（セル）</span>
      </td>
    </tr>
    <tr>
      <td class="c-table-td ${Link}">
        <span class="c-table-td-inner">3値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">a値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">う値（セル）</span>
      </td>
      <td class="c-table-td">
        <span class="c-table-td-inner">ウ値（セル）</span>
      </td>
    </tr>
  </tbody>
  `


  return TableWrapDom;
};


// 行でソート　昇順
const sortAscending = (rows, index) => {
    rows.sort((rowA, rowB) => {
    const cellA = rowA.cells[index].textContent;
    const cellB = rowB.cells[index].textContent;
    return cellA.localeCompare(cellB, 'ja', { numeric: true });
  });
};

// 行でソート　降順
const sortDescending = (rows, index) => {
    rows.sort((rowA, rowB) => {
    const cellA = rowA.cells[index].textContent;
    const cellB = rowB.cells[index].textContent;
    return cellB.localeCompare(cellA, 'ja', { numeric: true });
  });
};

// DOMを更新
const updateDOM = (tbody, rows) => {
  tbody.innerHTML = '';
  rows.forEach(row => {
    tbody.appendChild(row);
  });
};

// ソート
document.addEventListener('DOMContentLoaded', () => {
  const thButtons = document.querySelectorAll('[data-table-sort="button"]');
  thButtons.forEach((btn, index) => {
    btn.addEventListener('click', () => {
      const table = btn.closest('table');
      const tbody = table.querySelector('tbody');
      const rows = Array.from(tbody.querySelectorAll('tr'));
      
      const arrowWrapper = btn.querySelector('[data-table-sort-btn="arrow"]');
      if (!arrowWrapper) return; // トグルがなければ抜ける


      if (arrowWrapper.classList.contains('descending')) {
        arrowWrapper.classList.remove('descending');
        sortAscending(rows, index);
      } else {
        arrowWrapper.classList.add('descending');
        sortDescending(rows, index);
      }

      // DOMを更新
      updateDOM(tbody, rows);
    });
  });
});