import './toggle.scss';

export const createToggle = ({
  version = 'primary',
  input,
  inputId,
  isDisabled = false,
  errorMessage,
}) => {
  const toggleWrapDom = document.createElement('div');

  // class付与
  const disabled = isDisabled ? 'c-toggle--disabled' : '';
  const disabledWrap = isDisabled ? 'c-toggle-wrap--disabled' : '';
  const error = errorMessage ? 'c-toggle--error' : '';
  const toggleClass = ['c-toggle', disabled, error, `c-toggle--${version}`].join(' ')
  const toggleWrapClass = ['c-toggle-wrap', disabledWrap].join(' ')
  toggleWrapDom.className = toggleWrapClass

  // html作成
  toggleWrapDom.innerHTML = `
    <div class="c-toggle-inner">
      <input type="checkbox" id="toggle-${inputId}" name="toggleGroup" value="${input}" class="${toggleClass}">
      <label for="toggle-${inputId}" class="c-toggle-label">${input}</label>
    </div>
    ${errorMessage ? `<p class="c-toggle-error">${errorMessage}</p>` : ''}
  `
  return toggleWrapDom;
};
