import { createRadioButton } from './RadioButton';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Operation/RadioButton',
  tags: ['autodocs'],
  render: ({ label, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createRadioButton({ label, ...args });
  },
  argTypes: {
    input: { control: 'text' },
    inputId: { control: 'text' },
    input2: { control: 'text' },
    inputId2: { control: 'text' },
    version: {
      control: { type: 'select' },
      options: ['primary'],
    },
    isDisabled: { control: 'boolean' },
    errorMessage: { control: 'text', description: 'エラーメッセージを入力するとエラー状態になります' },
  },
};

// More on writing stories with args: https://storybook.js.org/docs/writing-stories/args
export const Primary = {
  args: {
    version: 'primary',
    input: '選択肢A',
    inputId: 'selectA',
    input2: '選択肢B',
    inputId2: 'selectB',
    isDisabled: false,
    errorMessage: '',
  },
};
