import { createSearch } from './Search';

// More on how to set up stories at: https://storybook.js.org/docs/writing-stories
export default {
  title: 'Operation/Search',
  tags: ['autodocs'],
  render: ({ label, ...args }) => {
    // You can either use a function to create DOM elements or use a plain html string!
    // return `<div>${label}</div>`;
    return createSearch({ label, ...args });
  },
  argTypes: {
    label: { control: 'text' },
    placeholder: { control: 'text' },
    errorMessage: { control: 'text' },
    version: {
      control: { type: 'select' },
      options: ['outlined', 'underlined'],
    },
    isDisabled: { control: 'boolean' },
    isRequired: { control: 'boolean' },
    errorMessage: { control: 'text', description: 'エラーメッセージを入力するとエラー状態になります' },
  },
};

// More on writing stories with args: https://storybook.js.org/docs/writing-stories/args
export const Outlined = {
  args: {
    version: 'outlined',
    label: '案件名',
    placeholder: '入力してください',
    isRequired: true,
    isDisabled: false,
    errorMessage: '',
  },
};

export const Underlined = {
  args: {
    version: 'underlined',
    label: '案件名',
    placeholder: '入力してください',
  },
};
