import './selector.scss';

export const createSelector = ({
  version = 'outlined',
  label,
  errorMessage,
  options,
  isDisabled = false,
  isRequired = false,
}) => {
  const selectorWrapDom = document.createElement('div');

  // class付与
  const disabled = isDisabled ? 'c-selector--disabled' : '';
  const disabledWrap = isDisabled ? 'c-selector-wrap--disabled' : '';
  const required = isRequired ? 'c-selector--required' : '';
  const error = errorMessage ? 'c-selector--error' : '';
  const selectorClass = ['c-selector', disabled, required, error, `c-selector--${version}`].join(' ')
  const selectorWrapClass = ['c-selector-wrap', disabledWrap].join(' ')
  selectorWrapDom.className = selectorWrapClass

  // html作成
  selectorWrapDom.innerHTML = `
    <div class="c-selector-label-wrap">
      <label class="c-selector-label" for="selector">${ label }</label>
      ${isRequired ? `<p class="c-selector-required">必須</p>` : ''}
    </div>
    <div class="${selectorClass}">
      <select id="selector" ${isDisabled ? 'disabled' : ''} ${isRequired ? 'required' : ''}>
${options.map((option, i) => (
`          <option value="${i == 0 ? '' : option }" ${i == 0 ? 'selected' : '' } ${i == 0 && isRequired ? 'disabled' : ''}>${option}</option>`
)).join('\n')}
      </select>
    </div>
    ${errorMessage ? `<p class="c-selector-error">${errorMessage}</p>` : ''}
  `


  return selectorWrapDom;
};
