import '../Table/table.scss';

export const createTable = ({
  version,
  checkbox,
  arrowIcon,
  threeDotIcon,
  Link,

}) => {
  const TableWrapDom = document.createElement('table');
  // versionで切り替えられるようにする
  Link = version === 'primary' ? `c-table-link`:'';

  // class付与
  TableWrapDom.classList = 'c-table'

  // チェックボックス
  checkbox = `<div class="c-checkBox-wrap ">
  <div class="c-checkBox-inner">
    <input type="checkbox" id="checkbox-selectA" name="checkboxGroup" value="" class="c-checkBox   c-checkBox--primary">
    <label for="checkbox-selectA" class="c-checkBox-label"></label>
  </div>
</div>`

// 三角アイコンSVG
arrowIcon = `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" class="svg" xmlns="http://www.w3.org/2000/svg">
<g id="svg-arrow">
<path id="svg-arrow-path" d="M7 9L12 14L17 9" stroke="#757575" stroke-width="2"/>
</g>
</svg>`;
threeDotIcon = `<svg width="18" height="4" viewBox="0 0 18 4" fill="none" class="svg" xmlns="http://www.w3.org/2000/svg">
<g id="svg-threedot">
<circle id="Ellipse 1" cx="2" cy="2" r="2" fill="#757575"/>
<circle id="Ellipse 2" cx="9" cy="2" r="2" fill="#757575"/>
<circle id="Ellipse 3" cx="16" cy="2" r="2" fill="#757575"/>
</g>
</svg>`;



  // html作成
  TableWrapDom.innerHTML = `
  <tr>
    <th></th>
    <th class="c-table-checkbox">${checkbox}</th>
    <th class="c-table-value"><div class="c-table-value-inner">見出し1 ${arrowIcon}</div></th>
    <th class="c-table-value"><div class="c-table-value-inner">見出し2 ${arrowIcon}</div></th>
    <th class="c-table-value"><div class="c-table-value-inner">見出し3 ${arrowIcon}</div></th>
    <th class="c-table-value"><div class="c-table-value-inner">見出し4 ${arrowIcon}</div></th>
    <th></th>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  <tr>
    <td class="c-table-number"></td>
    <td class="c-table-checkbox">${checkbox}</td>
    <td class="c-table-value ${Link}"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td class="c-table-value"><span>値（セル）</span></td>
    <td>${threeDotIcon}</td>
  </tr>
  `


  return TableWrapDom;
};


// テーブル左の数字を自動で順に表示
document.addEventListener('DOMContentLoaded', function() {
  // .c-table-numberを持つ全ての要素を取得
  var tableNumbers = document.querySelectorAll('.c-table-number');

  // 取得した各要素に対して連番を設定
  tableNumbers.forEach(function(element, index) {
    element.innerHTML = index + 1;
  });
});